/*
 * UIMTreeProcessor Class
 * version: 1.0 (11-16-2010)
 * 
 * Copyright (c) 2010 Vlad Shamgin (uimonster.com)
 * 
 * @requires jQuery v1.3.2 or later
 * @requires jsTree 1.0-rc1 or later
 *
 * Examples and documentation at: http://uimonster.com
 * Dual licensed under the MIT and GPL licenses:
 *   http://www.opensource.org/licenses/mit-license.php
 *   http://www.gnu.org/licenses/gpl.html
 */

var durchlauf = 0;
var myScroll = null;

function hidy()
{

	$("a:contains('Bookmarks')").css("visibility","hidden");
	$(".jstree-last .jstree-icon").first().hide();
	
	createScroller();
}

function createScroller()
{
	if(myScroll!=null)
	{
		myScroll.destroy();
		myScroll = null;
	}
	
	var momentCheck = true;
	if ((navigator.userAgent.match(/iPhone/i)) || (navigator.userAgent.match(/iPod/i)))	momentCheck = false;

	myScroll = new iScroll('jstree', { hScrollbar: false, vScrollbar: true, bounce:true, momentum:momentCheck, wheelAction: 'scroll'});
}

function refreshScroller()
{
	if(myScroll!=null)
	{
		/*
		var timeoutID2Scroller = window.setTimeout(function ()
		{
			window.clearTimeout(timeoutID2Scroller);
			myScroll.refresh();
		}, 200)
		*/
		
		myScroll.refresh();
	}
}

function TreeGotoSlide(_page)
{
	if(AgentRotation == false)
	{
		_page += 2;	
	}
	
	gotoSlide(_page);
}



		
function UIMTreeProcessor(data, treeEl) {
	this.data = data;
	this.treeEl = treeEl;
}

UIMTreeProcessor.prototype.initTree = function(data){
	this.treeEl.bind("loaded.jstree", function (event, data) {
			//jQuery("li").css('line-height', "24px");
			 hidy();
		}).jstree({
		"json_data" : {
			"data":data,
			"progressive_render":true
		},
		"themes" : {
			"theme" : "default",
			"dots" : true,
			"icons" : true
		},
	    "core":{
			"animation":0,
			"html_titles":true
		},
		"types" : {
			"types" : {
				"default" : {
					"valid_children" : [ "default" ],
					"hover_node" : true,
					"select_node" : function (e) {this.toggle_node(e);$("ul > li").removeClass('jstree-clicked');e.addClass('jstree-clicked');refreshScroller();return false;}
					/*
					
					"select_node": function (e) {
					   document.location = e.children("a").attr("href");
					   return false;
					}
					
					*/
				}
			}
		},                              
		"plugins" : [ "themes", "ui", "json_data", "types", "core" ]
		});
}

UIMTreeProcessor.prototype.doProcess = function(){
	//Find root:
	
	var _root = $(this.data).children(":first-child");
	
	
	var _a_feed = new Array();
	
	
	
	this.vsTraverse($(_root), _a_feed);

	
	var _treedata = [{"data":"<B>"+_root[0].attributes[0].nodeValue+"<B>", "children":_a_feed, "state":"open"}];
	this.initTree(_treedata);
}

UIMTreeProcessor.prototype.vsTraverse = function(node, arr){
	var _ch = $(node).children();
	
	for(var i=0; i<_ch.length; i++){
		var _vsArr = new Array();

		this.vsTraverse(_ch[i], _vsArr);
		
		var _a_att = this.vsTraverseAtt(_ch[i]);
		
		// keine Attribute-folder !!!
		_a_att = null;
		
		var ArrObj = new Object();
		ArrObj = {"title":_ch[i].nodeName, "icon" : "sourceimg/tree/assets/square.png"};	

		/*
		_vsArr.push(
		[
			{
					"data": ArrObj,
					"attr" : { "class" : "uim_attr"}
			}
		]);
		*/
		
		
		var namer = new Object();
		var checker = _ch[i].attributes.label.nodeValue;
		var colorArr ="";
		var thisIcon = "sourceimg/tree/assets/document.png";
				
		
		if(null!=_ch[i].firstChild && 3 == _ch[i].firstChild.nodeType)
		{

			// Hauptgruppen //
			
			if(_ch[i].firstChild.parentNode.parentElement.attributes.label.nodeValue == "Bookmarks" )
			{
				durchlauf += 1;
				
				//
				console.log("INFO:"+_ch[i].firstChild.parentNode.parentElement.attributes.label.nodeValue);
			
				//
				console.log("Ebene 1: "+_ch[i].attributes.label.nodeValue);
			
				/*
				if (checker.match(/Aktive Bauelemente/i) || checker.match(/Active Components/i)){
					colorArr = "bcd050";
					
					checker = "<div style='background-color:#bcd050;width:221px;float:left;overflow:hidden;'><img height=22 src=sourceimg/tree/assets/aktive_komponenten_2.gif align=left><div style='padding-left:4px;float:left;'> <B>"+_ch[i].attributes.label.nodeValue+"</B></div></div>";
				}
				*/
				
				checker = "<span style='font-weight:bold' onclick='TreeGotoSlide("+Number(_ch[i].attributes.link.nodeValue-1)+");'>"+checker+"</span>";
				
				namer = {"title":checker, "icon" : thisIcon};	
				
				//console.log(_vsArr);
				
				arr.push([{"data":namer, "children":_vsArr, "state":"closed"}]);
				
				
			}
			else
			{
				//console.log("A:" + _ch[i].attributes.label.nodeValue);
								
				
				
				checker = "<div class='class_"+durchlauf+"' style='width:309px;float:left;padding-left:4px;overflow:hidden;' onclick='TreeGotoSlide("+Number(_ch[i].attributes.link.nodeValue-1)+");'><nobr>"+_ch[i].attributes.label.nodeValue+"</nobr></div>";	
				
				namer = {"title":checker, "icon" : thisIcon};	
			
				arr.push([{"data":namer, "children":_vsArr, "state":"closed"}]);
			}
			
			//console.log("INFO:"+_ch[i].firstChild, _ch[i].firstChild.nodeType, _ch[i].firstChild.parentNode);
			//console.log("INFO2:"+_ch[i].firstChild.parentNode.parentElement.attributes.label.nodeValue);
		}
		else
		{
			
			//console.log("B:" + _ch[i].attributes.label.nodeValue);
			
			thisIcon = "sourceimg/tree/assets/document.png";
			checker = "<div class='class_"+durchlauf+"' style='width:309px;float:left;padding-left:4px;overflow:hidden;' onclick='TreeGotoSlide("+Number(_ch[i].attributes.link.nodeValue-1)+");'><nobr><img src=sourceimg/tree/assets/square.png align=left><nobr>"+_ch[i].attributes.label.nodeValue+"</nobr></div>";	
			
			namer = {"title":checker, "icon" : thisIcon};	
			
			arr.push([{"data":namer, "state":"closed"}]);
			
			/*
			if(null!=_ch[i].firstChild && 3 == _ch[i].firstChild.nodeType)
			{	

				arr.push([{"data":namer, "children":_vsArr, "state":"closed"}]);
	
			}else{
				arr.push([{"data":namer, "state":"closed"}]);
			}
			*/
		}
	}
}

// Attribute // ["name:Connect us - Bachmann","page:932"]

UIMTreeProcessor.prototype.vsTraverseAtt = function(node){
	var _a_atts = null;
	
	if(null!=node.attributes && node.attributes.length > 1){
		_a_atts = new Array();
		
		for(var i=0; i<node.attributes.length; i++)
		{	
			_a_atts.push(node.attributes[i].nodeName + ":" + node.attributes[i].nodeValue);
		}
	}
	
	return _a_atts;
}
